
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Digital Elevation Model Extraction SRTM3 V4
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'ToolsDEMExtractionSRTM4'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STATE' , 'GEO-GLOBAL'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_HEMISPHERE' , 'NONE'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION' , 'GEO'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ZONE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ELLIPSOID' , 'WGS84'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_DATUM_SHIFT' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_REFERENCE_HEIGHT' , '0.0'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_NORTHING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_EASTING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LATITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LONGITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_LATITUDE_OF_TRUE_SCALE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SCALE_FACTOR' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL1' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL2' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SPHERE_RADIUS' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'DEM_FTP_ADDRESSES.SRTM_VERSION4_FTP_ADDRESS' , 'https://srtm.csi.cgiar.org'
   OB->SetParam , 'DEM_FTP_ADDRESSES.SRTM_VERSION4_FTP_LOCAL_PATH' , 'wp-content/uploads/files/srtm_5x5/TIFF/'
   OB->SetParam , 'DEM_FTP_ADDRESSES.AW3D30_FTP_ADDRESS' , 'https://www.eorc.jaxa.jp/ALOS/aw3d30/data/release_v2003/'
   OB->SetParam , 'DEM_FTP_ADDRESSES.AW3D30_HTTP_LOGIN_ADDRESS' , 'https://www.eorc.jaxa.jp/ALOS/en/aw3d30/data/index.htm'
   OB->SetParam , 'SARSNT_PROXY.PROXY_URL' , ''
   OB->SetParam , 'SARSNT_PROXY.PROXY_USERNAME' , ''
   OB->SetParam , 'SARSNT_PROXY.PROXY_PASSWORD' , ''
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.OUTPUT_FILE_DEM_VAL' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.INT_TYPE_VAL' , '4th_order_cc'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.SLOPE_FLAG_VAL' , 'NotOK'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.EAST_START_VAL' , '0.0000000'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.EAST_END_VAL' , '0.0000000'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.NORTH_START_VAL' , '0.0000000'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.NORTH_END_VAL' , '0.0000000'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.GRID_SIZE_X_VAL' , '90.000000'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.GRID_SIZE_Y_VAL' , '90.000000'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.REPLACE_DUMMY_WITH_MIN_VAL' , 'NotOK'
   temp_value = []
   temp_value = [temp_value,'USER_OPTIONAL_PARAMETER']
   ;OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.REFERENCE_SR_IMAGE_VAL' , temp_value
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.SOURCE_DEM_TYPE_VAL' , 'TIF-SRTM-3'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.INTERPOL_WIN_SIZE_VAL' , '7.0000000'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.SUBTRACT_GEOID' , 'OK'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.RELAX_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_TOOLS_DEM_EXTRACTION_SRTM3_V4_CMD.MAX_FORWARD_BACKWARD_ADMITTED' , '25.000000'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

