
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : SBAS Inversion Step2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'InSARStackSBASInversionStep2'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   ;OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_GCP_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_METHOD' , 'RemoveResidualPhase'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_STACKING' , 'StackAllProductsRefinement'
   OB->SetParam , 'REFINEMENT_CMD.RADIUS' , '37.500000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_RES_PHASE_POLY_DEGREE' , '3.0000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_PRIORI_THR' , '25.000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_POSTERIORI_THR' , '50.000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_MINIMUM_BASELINE_THR' , '0.0000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_RMS_RATIO' , '3.0000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_SLOPE_MAX_THRESHOLD' , '15.000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_COHERENCE_PERCENTAGE' , '60.000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_HEIGHT_PERCENTAGE' , '60.000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_DISPLACEMENT_PERCENTAGE' , '50.000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_MIN_CLUSTER_SIZE' , '5.0000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_MUSIGMA_PERCENTAGE' , '40.000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_ORBIT_INTERPOL' , '100.00000'
   ;OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_OUT_ROOT' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.AUXILIARY_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.REBUILD_ALL_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.PRODUCT_COHERENCE_THRESHOLD' , '0.30000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.DISPLACEMENT_MODEL_TYPE' , 'same_as_first'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.PERIODIC_PERIOD' , '365.00000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.ESTIMATE_RESIDUAL_HEIGHT' , 'same_as_first'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.DISCONNECTED_BLOCKS_TYPE' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.MIN_VALID_INTERF_PERC' , '65.000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.MIN_VALID_IMAGE_PERC' , '90.000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.REJECT_MIN_VALID_INTERF_PER_IMAGE' , '3.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.REDUNDANCY_MIN_VALID_INTERF_PER_IMAGE' , '5.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.ATMOSPHERE_LP_METERS' , '1600.0000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.ATMOSPHERE_HP_DAYS' , '365.00000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.SKIP_ATMOSPHERE_ESTIMATION_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.WEIGHT_SOLUTION_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.REJECT_OUTLIARS_H_THR' , '-1.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.REJECT_OUTLIARS_D_THR' , '-1.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INVERSION_STEP2_CMD.INVERSION_SVD_TYPE' , 'jacobi'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

