
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : SBAS Geocoding
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'InSARStackSBASGeocode'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   ;OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_GCP_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_METHOD' , 'RemoveResidualPhase'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_STACKING' , 'StackAllProductsRefinement'
   OB->SetParam , 'REFINEMENT_CMD.RADIUS' , '37.500000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_RES_PHASE_POLY_DEGREE' , '3.0000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_PRIORI_THR' , '25.000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_POSTERIORI_THR' , '50.000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_MINIMUM_BASELINE_THR' , '0.0000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_RMS_RATIO' , '3.0000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_SLOPE_MAX_THRESHOLD' , '15.000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_COHERENCE_PERCENTAGE' , '60.000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_HEIGHT_PERCENTAGE' , '60.000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_DISPLACEMENT_PERCENTAGE' , '50.000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_MIN_CLUSTER_SIZE' , '5.0000000'
   OB->SetParam , 'REFINEMENT_CMD.AUTOMATIC_MUSIGMA_PERCENTAGE' , '40.000000'
   OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_ORBIT_INTERPOL' , '100.00000'
   ;OB->SetParam , 'REFINEMENT_CMD.REFINEMENT_OUT_ROOT' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_ORBIT_INTERPOL' , '10.000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_BLOCK_SIZE' , '30000.000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_BLOCK_OVERLAP' , '50.000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_RG_GRID_SIZE' , '25.000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_AZ_GRID_SIZE' , '25.000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_MEAN_BOX_SIZE' , '3.0000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_INTERPOL_BOX_SIZE' , '7.0000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_RELAX_FLAG' , 'NotOK'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_DUMMY_REMOVAL_FLAG' , 'NotOK'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STATE' , 'GEO-GLOBAL'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_HEMISPHERE' , 'NONE'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION' , 'GEO'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ZONE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ELLIPSOID' , 'WGS84'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_DATUM_SHIFT' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_REFERENCE_HEIGHT' , '0.0'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_NORTHING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_EASTING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LATITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LONGITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_LATITUDE_OF_TRUE_SCALE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SCALE_FACTOR' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL1' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL2' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SPHERE_RADIUS' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'DISPLACEMENT_PROJECTION_CMD.GENERATE_LOS_FLAG' , 'OK'
   OB->SetParam , 'DISPLACEMENT_PROJECTION_CMD.GENERATE_VERTICAL_FLAG' , 'NotOK'
   OB->SetParam , 'DISPLACEMENT_PROJECTION_CMD.GENERATE_MAX_SLOPE_FLAG' , 'NotOK'
   OB->SetParam , 'DISPLACEMENT_PROJECTION_CMD.GENERATE_USER_CUSTOM_FLAG' , 'NotOK'
   OB->SetParam , 'DISPLACEMENT_PROJECTION_CMD.CUSTOM_AZIMUTH_ANGLE' , '0.0000000'
   OB->SetParam , 'DISPLACEMENT_PROJECTION_CMD.CUSTOM_INCLINATION_ANGLE' , '0.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.AUXILIARY_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   ;OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.DEM_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.SHAPE_MASK_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.REBUILD_ALL_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.PRECISION_HEIGHT_THR' , '5.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.PRECISION_VELOCITY_THR' , '8.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.COHERENCE_THR' , '0.10000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.WATER_BODY_MASK_DB' , '0.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.GENERATE_RASTER_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.GENERATE_SHAPE_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.MAX_POINT_IN_SHAPE' , '200000.00'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.SHAPE_TIME_SERIES_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.SHAPE_COUNTER_SERIES_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.SET_CODE_FOR_TEMPORAL_INTERPOL_VALUES_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.SET_CODE_FOR_SPATIAL_INTERPOL_VALUES_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_GEOCODE_CMD.SERIES_DBF_STRING' , 'D_'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

