
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Phase Unwrapping
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'InSARPhaseUnwrapping'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'UPHA_CMD.UPHA_METHOD_TYPE' , 'MCF'
   OB->SetParam , 'UPHA_CMD.UPHA_MAKE_3D' , 'NotOK'
   OB->SetParam , 'UPHA_CMD.UPHA_LEVELS_NBR' , '1.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_AZ_SCALE_FACTOR' , '3.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_RG_SCALE_FACTOR' , '3.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_COH_THRESHOLD' , '0.30000000'
   OB->SetParam , 'UPHA_CMD.UPHA_GROW_RDUMMY' , '-9999.0000'
   OB->SetParam , 'UPHA_CMD.UPHA_GROW_MAX_COH' , '0.95000000'
   OB->SetParam , 'UPHA_CMD.UPHA_GROW_COH_JUMP' , '0.050000000'
   OB->SetParam , 'UPHA_CMD.UPHA_GROW_REBIN_OUT' , '8.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_TILE_NUMBER_ROW' , '800.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_TILE_NUMBER_COL' , '800.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_TILE_OVERLAP_ROW' , '200.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_TILE_OVERLAP_COL' , '300.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_COST_CC_THRESHOLD' , '-1.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_HEIGHT_STEP_NR' , '200.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_HEIGHT_SPAN' , '10.000000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_VEL_STEP_NR' , '200.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_VEL_SPAN' , '5.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_MIN_VALID_PERC' , '60.000000'
   OB->SetParam , 'UPHA_CMD.MIN_SCALAR_COST' , '0.0000000'
   OB->SetParam , 'UPHA_CMD.MAKE_UNWRAPPING_MAI_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_PHASE_UNWRAPPING_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   OB->SetParam , 'MAIN_INSAR_PHASE_UNWRAPPING_CMD.INFILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_UNWRAPPING_CMD.OUTFILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_UNWRAPPING_CMD.COHERENCEFILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_UNWRAPPING_CMD.MODE_COMPUTATION_FOR_BISTATIC_FLAG' , 'OK'
   ;OB->SetParam , 'MAIN_INSAR_PHASE_UNWRAPPING_CMD.KFACTOR_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_PHASE_UNWRAPPING_CMD.INIT_FROM_3D' , 'NotOK'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

