
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Phase to Height Conversion and Geocoding
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'InSARPhaseToHeight'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STATE' , 'GEO-GLOBAL'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_HEMISPHERE' , 'NONE'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION' , 'GEO'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ZONE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ELLIPSOID' , 'WGS84'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_DATUM_SHIFT' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_REFERENCE_HEIGHT' , '0.0'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_NORTHING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_EASTING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LATITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LONGITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_LATITUDE_OF_TRUE_SCALE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SCALE_FACTOR' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL1' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL2' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SPHERE_RADIUS' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_ORBIT_INTERPOL' , '10.000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_BLOCK_SIZE' , '30000.000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_BLOCK_OVERLAP' , '50.000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_RG_GRID_SIZE' , '25.000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_AZ_GRID_SIZE' , '25.000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_MEAN_BOX_SIZE' , '3.0000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_INTERPOL_BOX_SIZE' , '7.0000000'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_RELAX_FLAG' , 'NotOK'
   OB->SetParam , 'GEOCODE_CMD.GEOCODE_DUMMY_REMOVAL_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.MASTER_FILE' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.SLAVE_FILE' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.INPUT_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.SYNTHETIC_FILE' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.COHERENCE_FILE' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.COHERENCE_THRESHOLD' , '0.30000000'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.OUTPUT_ROOT_FILE' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.HEIGHT_LP_WAVELET_SIZE' , '300.00000'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.MAKE_RASTER_PRODUCT_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.MAKE_SHAPE_PRODUCT_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.MAKE_LAS_PRODUCT_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.ALLOW_SKIP_REFINEMENT' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.GENERATE_DEM_PRODUCT_TYPE' , 'dem_ellipsoidal_only'
   OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.GEOID_TYPE' , 'EGM96'
   ;OB->SetParam , 'MAIN_INSAR_PHASE_TO_HEIGHT.GEOID_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

