
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Multitemporal Features
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'BasicFeMultiTemporalFeatures'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   temp_value = []
   temp_value = [temp_value,'USER_PARAMETER_TO_FILL']
   OB->SetParam , 'MAIN_MT_FEAT_EXT.INPUT_FILE_LIST' , temp_value
   OB->SetParam , 'MAIN_MT_FEAT_EXT.OUTPUT_ROOT_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.INTERP_TYPE' , '4th_order_cc'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MEAN' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.STD' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MEDIAN' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.GRADIENT' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MAX' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MIN' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.SPAN_MAX_LESS_MIN' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MAX_LESS_MIN_SUP' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MAX_LESS_MIN_INF' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.SPAN_MAX_ON_MIN' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MAX_ON_MIN_SUP' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MAX_ON_MIN_INF' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MU_SIGMA' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.COEFF_OF_VAR' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.INFO_DATE' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MODE' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MAKE_COV_MIN_GRAD_RGB_FLAG' , 'OK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.NORMALIZE' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.OUT_DB' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.HISTO_BIN_NBR' , '-9999.0000'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.HISTO_BIN_WIDTH' , '-9999.0000'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.HISTO_MAX' , '-9999.0000'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.HISTO_MIN' , '-9999.0000'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.COMMON_AREA' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.IS_OPTICAL' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.GENERATE_SHAPE_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_MT_FEAT_EXT.MAX_POINT_IN_SHAPE' , '500000.00'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

