
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Slant Range Mosaic
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'ToolsSlantRangeMosaic'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_START_SHIFT_RANGE' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_START_SHIFT_AZIMUTH' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_COEFF_RANGE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_COEFF_AZIMUTH' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_RES_COEFF_RANGE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_RES_COEFF_AZIMUTH' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_BORDER_DINSTANCE_RANGE' , '64.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_BORDER_DINSTANCE_AZIMUTH' , '128.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_SHIFT_DINST_MULTIPLE' , '2.5000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_SHIFT_DINST_MULTIPLE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_MAXIMIZE_THE_VARIANCE_FLAG' , 'NotOK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VARIANCE_THRESHOLD' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_SKIP_COREGISTRATION_FLAG' , 'NotOK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_ORBITS_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_AMPLITUDE_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_COHERENCE_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_ACTIVATE_TEST_ON_ORBIT_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_ORBIT_INTERPOLATION' , '10.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_TEST' , '512.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_TEST' , '1024.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_MAX_SHIFT_TEST' , '16.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VALIDITY_THRESHOLD_TEST' , '0.12000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_RANGE_WIN_SIZE' , '1024.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_AZIMUTH_WIN_SIZE' , '4096.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_RANGE_POSITION' , '-1.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_AZIMUTH_POSITION' , '-1.0000000'
   ;OB->SetParam , 'COREGISTRATION_CMD.INPUT_SHAPE_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_NUMBER_CC' , '10.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_NUMBER_CC' , '15.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_CC' , '256.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_CC' , '512.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_CC' , '1.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VALIDITY_THRESHOLD_CC' , '0.25000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_FINE' , '8.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_NUMBER_FINE' , '40.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_NUMBER_FINE' , '60.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_FINE' , '32.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_FINE' , '32.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_SNR_THRESHOLD' , '3.2000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_COHERENCE' , '2.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_COH_REJECT_THRESHOLD' , '0.20000000'
   OB->SetParam , 'COREGISTRATION_CMD.COREGISTRATION_WITH_DEM_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_TOOLS_SLANT_RANGE_MOSAIC_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   temp_value = []
   temp_value = [temp_value,'USER_PARAMETER_TO_FILL']
   OB->SetParam , 'MAIN_TOOLS_SLANT_RANGE_MOSAIC_CMD.INPUT_FILE_LIST' , temp_value
   OB->SetParam , 'MAIN_TOOLS_SLANT_RANGE_MOSAIC_CMD.OUTPUT_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_TOOLS_SLANT_RANGE_MOSAIC_CMD.MAKE_SCALE_FLAG' , 'OK'
   OB->SetParam , 'MAIN_TOOLS_SLANT_RANGE_MOSAIC_CMD.FORCE_MAKE_SAMPLING_FLAG' , 'NotOK'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

