
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : SBAS Interferogram Generation and Unwrapping
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'InSARStackSBASInterferogramGeneration'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'CLUSTER_PARAMETERS_CMD.USE_CLUSTER' , 'NotOK'
   OB->SetParam , 'CLUSTER_PARAMETERS_CMD.CLIENT_ADDRESS' , '127.0.0.1'
   OB->SetParam , 'CLUSTER_PARAMETERS_CMD.XROAD_ADDRESS' , '127.0.0.1'
   OB->SetParam , 'CLUSTER_PARAMETERS_CMD.XROAD_PORT' , '5555.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'INTERF_CMD.INT_SPECTRAL_SHIFT_FILTER_FLAG' , 'OK'
   OB->SetParam , 'INTERF_CMD.INT_DOPPLER_FILTER_FLAG' , 'NotOK'
   OB->SetParam , 'INTERF_CMD.INT_BLOCKSIZE' , '4000.0000'
   OB->SetParam , 'INTERF_CMD.INT_BLOCK_OVERLAP' , '50.000000'
   OB->SetParam , 'INTERF_CMD.INT_MAI_SPLIT_NUMBER' , '1.0000000'
   ;OB->SetParam , 'INTERF_CMD.INT_SPECTRAL_DIVERSITY_AVOID_AREA' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'INTERF_CMD.INT_SPECTRAL_DIVERSITY_AVOID_FLAG' , 'NotOK'
   OB->SetParam , 'INTERF_CMD.INT_MOSAIC_OFFSET_CAL_FLAG' , 'OK'
   OB->SetParam , 'INTERF_CMD.INT_MOSAIC_AZ_CAL_FLAG' , 'NotOK'
   OB->SetParam , 'INTERF_CMD.INT_MOSAIC_RG_CAL_FLAG' , 'NotOK'
   OB->SetParam , 'INTERF_CMD.INT_MOSAIC_ONLY_FLAG' , 'NotOK'
   OB->SetParam , 'INTERF_CMD.INT_COHERENCE_MOSAIC_THRESHOLD' , '0.0000000'
   OB->SetParam , 'FLAT_CMD.MAKE_FLATTENING_FLAG' , 'OK'
   ;OB->SetParam , 'FLAT_CMD.SYNT_GCP_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'FLAT_CMD.SYNT_ORBIT_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'FLAT_CMD.SYNT_PHASE_INTERP_BOX_SIZE' , '11.000000'
   OB->SetParam , 'FLAT_CMD.SYNT_PHASE_MEAN_BOX_SIZE' , '5.0000000'
   OB->SetParam , 'FLAT_CMD.SYNT_PHASE_ORBIT_INTERP_VAL' , '100.00000'
   OB->SetParam , 'FLAT_CMD.SYNT_RESAMP_GRID_SIZE' , '-1.0000000'
   OB->SetParam , 'FLAT_CMD.SYNT_BLOCKSIZE' , '30000.000'
   OB->SetParam , 'FLAT_CMD.SYNT_SPLIT_IMAGES' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_OPTIMAL_RESOLUTION_FLAG' , 'OK'
   OB->SetParam , 'FLAT_CMD.SYNT_AUTOMATIC_SLAVE_ORBITAL_CORRECTION_FLAG' , 'NotOK'
   ;OB->SetParam , 'FLAT_CMD.SYNT_ORBIT_CORRECTION_FILE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'FLAT_CMD.SYNT_RESOLUTION_FLAG' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_LIA_FLAG' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_REBUILD_ALL_FLAG' , 'OK'
   OB->SetParam , 'FLAT_CMD.SYNT_REMOVE_RESIDUAL_FRINGES_FLAG' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_AZIMUTH_FFT_SIZE' , '2048.0000'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_RANGE_FFT_SIZE' , '2048.0000'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_AZIMUTH_FFT_NUMBER' , '30.000000'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_RANGE_FFT_NUMBER' , '10.000000'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_POLY_DEGREE' , '10.000000'
   OB->SetParam , 'FLAT_CMD.SYNT_REMOVE_LOW_PASS_SIZE' , '0.0000000'
   OB->SetParam , 'FLAT_CMD.SYNT_COMPUTE_KFACTOR' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_RG_LOOKS_NBR' , '1.0000000'
   OB->SetParam , 'FLAT_CMD.SYNT_AZ_LOOKS_NBR' , '1.0000000'
   OB->SetParam , 'FILTERING_CMD.FILTERING_METHOD' , 'GOLDSTEIN'
   OB->SetParam , 'FILTERING_CMD.COH_AZ_BOXSIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.COH_RG_BOXSIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.ADAPTIVE_COHERENCE_CORR_MAX_AZ_SIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.ADAPTIVE_COHERENCE_CORR_MAX_RG_SIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.COH_REM_LOCAL_FREQ_RG_BOXSIZE' , '0.0000000'
   OB->SetParam , 'FILTERING_CMD.COH_REM_LOCAL_FREQ_AZ_BOXSIZE' , '0.0000000'
   OB->SetParam , 'FILTERING_CMD.BOXCAR_WIDTH' , '4.0000000'
   OB->SetParam , 'FILTERING_CMD.BOXCAR_SNR' , '0.25000000'
   OB->SetParam , 'FILTERING_CMD.ADAPTIVE_MEAN_FACTOR' , '1.2000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_WINSIZE' , '64.000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_WIN_OVERLAP_PERC' , '80.000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_SMOOTH_WINSIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_LOWPASS_PERC' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_ALPHA_ADAPT_FLAG' , 'OK'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_MIN_ALPHA' , '0.30000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_MAX_ALPHA' , '2.5000000'
   OB->SetParam , 'FILTERING_CMD.COHERENCE_FROM_FINT_FLAG' , 'OK'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_H_FACTOR' , '30.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_T_FACTOR' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_WINDOW_SIZE' , '21.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_KERNEL_SIZE' , '7.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_MIN_KERNEL_SIZE' , '3.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_NR_OF_ITERATIONS' , '3.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_FFT_SIZE' , '64.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_SNR_THRESHOLD' , '10.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_BOXCAR_WINSIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_AGGREGATION_WINSIZE' , '1.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_MIN_LOOKS' , '10.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_CPM_ALPHA' , '1.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_CPM_D0' , '0.40000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_DARK_POINT_DB' , '-15.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_BRIGHT_POINT_DB' , '3.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_OUTLIAR_DB' , '10.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_ENL' , '-1.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_METHOD_TYPE' , 'MCF'
   OB->SetParam , 'UPHA_CMD.UPHA_MAKE_3D' , 'NotOK'
   OB->SetParam , 'UPHA_CMD.UPHA_LEVELS_NBR' , '1.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_AZ_SCALE_FACTOR' , '3.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_RG_SCALE_FACTOR' , '3.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_COH_THRESHOLD' , '0.30000000'
   OB->SetParam , 'UPHA_CMD.UPHA_GROW_RDUMMY' , '-9999.0000'
   OB->SetParam , 'UPHA_CMD.UPHA_GROW_MAX_COH' , '0.95000000'
   OB->SetParam , 'UPHA_CMD.UPHA_GROW_COH_JUMP' , '0.050000000'
   OB->SetParam , 'UPHA_CMD.UPHA_GROW_REBIN_OUT' , '8.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_TILE_NUMBER_ROW' , '800.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_TILE_NUMBER_COL' , '800.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_TILE_OVERLAP_ROW' , '200.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_TILE_OVERLAP_COL' , '300.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_MCF_COST_CC_THRESHOLD' , '-1.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_HEIGHT_STEP_NR' , '200.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_HEIGHT_SPAN' , '10.000000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_VEL_STEP_NR' , '200.00000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_VEL_SPAN' , '5.0000000'
   OB->SetParam , 'UPHA_CMD.UPHA_3D_MIN_VALID_PERC' , '60.000000'
   OB->SetParam , 'UPHA_CMD.MIN_SCALAR_COST' , '0.0000000'
   OB->SetParam , 'UPHA_CMD.MAKE_UNWRAPPING_MAI_FLAG' , 'NotOK'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STATE' , 'GEO-GLOBAL'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_HEMISPHERE' , 'NONE'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION' , 'GEO'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ZONE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ELLIPSOID' , 'WGS84'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_DATUM_SHIFT' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_REFERENCE_HEIGHT' , '0.0'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_NORTHING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_EASTING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LATITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LONGITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_LATITUDE_OF_TRUE_SCALE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SCALE_FACTOR' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL1' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL2' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SPHERE_RADIUS' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'COREGISTRATION_CMD.CC_START_SHIFT_RANGE' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_START_SHIFT_AZIMUTH' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_COEFF_RANGE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_COEFF_AZIMUTH' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_RES_COEFF_RANGE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_RES_COEFF_AZIMUTH' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_BORDER_DINSTANCE_RANGE' , '64.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_BORDER_DINSTANCE_AZIMUTH' , '128.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_SHIFT_DINST_MULTIPLE' , '2.5000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_SHIFT_DINST_MULTIPLE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_MAXIMIZE_THE_VARIANCE_FLAG' , 'NotOK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VARIANCE_THRESHOLD' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_SKIP_COREGISTRATION_FLAG' , 'NotOK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_ORBITS_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_AMPLITUDE_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_COHERENCE_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_ACTIVATE_TEST_ON_ORBIT_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_ORBIT_INTERPOLATION' , '10.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_TEST' , '512.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_TEST' , '1024.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_MAX_SHIFT_TEST' , '16.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VALIDITY_THRESHOLD_TEST' , '0.12000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_RANGE_WIN_SIZE' , '1024.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_AZIMUTH_WIN_SIZE' , '4096.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_RANGE_POSITION' , '-1.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_AZIMUTH_POSITION' , '-1.0000000'
   ;OB->SetParam , 'COREGISTRATION_CMD.INPUT_SHAPE_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_NUMBER_CC' , '10.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_NUMBER_CC' , '15.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_CC' , '256.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_CC' , '512.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_CC' , '1.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VALIDITY_THRESHOLD_CC' , '0.25000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_FINE' , '8.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_NUMBER_FINE' , '40.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_NUMBER_FINE' , '60.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_FINE' , '32.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_FINE' , '32.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_SNR_THRESHOLD' , '3.2000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_COHERENCE' , '2.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_COH_REJECT_THRESHOLD' , '0.20000000'
   OB->SetParam , 'COREGISTRATION_CMD.COREGISTRATION_WITH_DEM_FLAG' , 'NotOK'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.EXTERNAL_SENSOR' , 'NOT_SELECTED'
   ;OB->SetParam , 'ATMOSPHERE_PD_CMD.WATER_VAPOUR_FILE_MASTER' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'ATMOSPHERE_PD_CMD.WATER_VAPOUR_FILE_SLAVE' , 'USER_OPTIONAL_PARAMETER'
   temp_value = []
   temp_value = [temp_value,'USER_OPTIONAL_PARAMETER']
   ;OB->SetParam , 'ATMOSPHERE_PD_CMD.WATER_VAPOUR_FILE_LIST' , temp_value
   OB->SetParam , 'ATMOSPHERE_PD_CMD.MERIS_CONVERSION_FACTOR_TYPE' , 'NoMethod'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.MERIS_USE_CLOUD_MASK' , 'OK'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.MERIS_USE_REFLECTANCE_MASK' , 'OK'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.MERIS_USE_DIFF_PRESSURE_MASK' , 'NotOK'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.INTERP_BOX_SIZE' , '11.000000'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.RELAX_FLAG' , 'OK'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.MEAN_BOX_SIZE' , '5.0000000'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.ORBIT_INTERP_VAL' , '100.00000'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.BLOCKSIZE' , '4000.0000'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.RESAMP' , '4th_order_cc'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.REPROJECT_LOS_FLAG' , 'NotOK'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.HEIGHT_CORRELATION_FLAG' , 'NotOK'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.H_CORR_HP_SIZE' , '20000.000'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.H_CORR_HC_SIZE' , '4000.0000'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.H_CORR_STD_FACTOR' , '1.5000000'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.H_CORR_MIN_CROSS' , '0.30000000'
   OB->SetParam , 'ATMOSPHERE_PD_CMD.H_CORR_MIN_VALID_NUMBER' , '100.00000'
   ;OB->SetParam , 'SBAS_GEOPHYSICAL_MODEL_CMD.UP_COMPONENT_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'SBAS_GEOPHYSICAL_MODEL_CMD.NORTH_COMPONENT_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'SBAS_GEOPHYSICAL_MODEL_CMD.EAST_COMPONENT_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'SBAS_GEOPHYSICAL_MODEL_CMD.EVENT_DATE_HOUR_' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.AUXILIARY_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   ;OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.DEM_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.REBUILD_ALL_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.RG_LOOKS_NBR' , '1.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.AZ_LOOKS_NBR' , '5.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.GRID_SIZE_FOR_SUGGESTED_LOOKS' , '25.000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.INTERPOLATION_TYPE' , '4th_order_cc'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.ALLOW_CLUSTER_INCREMENTAL_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.MULTI_UNWRAPPING_PARALLEL_NR' , '2.0000000'
   ;OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.AVOID_AREA_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.LAYOVER_SHADOW_MASK_FLAG' , 'OK'
   ;OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.CLASSIFICATION_MASK_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.CLASSIFICATION_MASK_ID_LIST' , ''
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.ELEVATION_MASK_THRESHOLD' , '-1.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.ELEVATION_MASK_START_MONTH' , '11.000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.ELEVATION_MASK_END_MONTH' , '3.0000000'
   OB->SetParam , 'MAIN_INSAR_STACK_SBAS_INTERFEROGRAM_GENERATION_CMD.KEEP_COREG_ANCILLARY_INFO' , 'NotOK'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

