
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Synthetic Phase Generation and Flattening
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'InSARSyntPhaseGenerationAndFlattening'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'FLAT_CMD.MAKE_FLATTENING_FLAG' , 'OK'
   ;OB->SetParam , 'FLAT_CMD.SYNT_GCP_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'FLAT_CMD.SYNT_ORBIT_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'FLAT_CMD.SYNT_PHASE_INTERP_BOX_SIZE' , '11.000000'
   OB->SetParam , 'FLAT_CMD.SYNT_PHASE_MEAN_BOX_SIZE' , '5.0000000'
   OB->SetParam , 'FLAT_CMD.SYNT_PHASE_ORBIT_INTERP_VAL' , '100.00000'
   OB->SetParam , 'FLAT_CMD.SYNT_RESAMP_GRID_SIZE' , '-1.0000000'
   OB->SetParam , 'FLAT_CMD.SYNT_BLOCKSIZE' , '30000.000'
   OB->SetParam , 'FLAT_CMD.SYNT_SPLIT_IMAGES' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_OPTIMAL_RESOLUTION_FLAG' , 'OK'
   OB->SetParam , 'FLAT_CMD.SYNT_AUTOMATIC_SLAVE_ORBITAL_CORRECTION_FLAG' , 'NotOK'
   ;OB->SetParam , 'FLAT_CMD.SYNT_ORBIT_CORRECTION_FILE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'FLAT_CMD.SYNT_RESOLUTION_FLAG' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_LIA_FLAG' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_REBUILD_ALL_FLAG' , 'OK'
   OB->SetParam , 'FLAT_CMD.SYNT_REMOVE_RESIDUAL_FRINGES_FLAG' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_AZIMUTH_FFT_SIZE' , '2048.0000'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_RANGE_FFT_SIZE' , '2048.0000'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_AZIMUTH_FFT_NUMBER' , '30.000000'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_RANGE_FFT_NUMBER' , '10.000000'
   OB->SetParam , 'FLAT_CMD.SYNT_FFT_POLY_DEGREE' , '10.000000'
   OB->SetParam , 'FLAT_CMD.SYNT_REMOVE_LOW_PASS_SIZE' , '0.0000000'
   OB->SetParam , 'FLAT_CMD.SYNT_COMPUTE_KFACTOR' , 'NotOK'
   OB->SetParam , 'FLAT_CMD.SYNT_RG_LOOKS_NBR' , '1.0000000'
   OB->SetParam , 'FLAT_CMD.SYNT_AZ_LOOKS_NBR' , '1.0000000'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STATE' , 'GEO-GLOBAL'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_HEMISPHERE' , 'NONE'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION' , 'GEO'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ZONE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_ELLIPSOID' , 'WGS84'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_DATUM_SHIFT' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_REFERENCE_HEIGHT' , '0.0'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_NORTHING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_PROJECTION_DATUM_FALSE_EASTING' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LATITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_CENTRAL_OF_PROJ_LONGITUDE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_LATITUDE_OF_TRUE_SCALE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SCALE_FACTOR' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL1' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_STANDARD_PARALLEL2' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'OUT_CARTOGRAPHIC_SYSTEM.OCS_SPHERE_RADIUS' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'COREGISTRATION_CMD.CC_START_SHIFT_RANGE' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_START_SHIFT_AZIMUTH' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_COEFF_RANGE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_COEFF_AZIMUTH' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_RES_COEFF_RANGE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_NUMBER_RES_COEFF_AZIMUTH' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_BORDER_DINSTANCE_RANGE' , '64.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_BORDER_DINSTANCE_AZIMUTH' , '128.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_SHIFT_DINST_MULTIPLE' , '2.5000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_SHIFT_DINST_MULTIPLE' , '3.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_MAXIMIZE_THE_VARIANCE_FLAG' , 'NotOK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VARIANCE_THRESHOLD' , '0.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_SKIP_COREGISTRATION_FLAG' , 'NotOK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_ORBITS_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_AMPLITUDE_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_FROM_COHERENCE_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_ACTIVATE_TEST_ON_ORBIT_FLAG' , 'OK'
   OB->SetParam , 'COREGISTRATION_CMD.CC_ORBIT_INTERPOLATION' , '10.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_TEST' , '512.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_TEST' , '1024.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_MAX_SHIFT_TEST' , '16.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VALIDITY_THRESHOLD_TEST' , '0.12000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_RANGE_WIN_SIZE' , '1024.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_AZIMUTH_WIN_SIZE' , '4096.0000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_RANGE_POSITION' , '-1.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_INIT_AZIMUTH_POSITION' , '-1.0000000'
   ;OB->SetParam , 'COREGISTRATION_CMD.INPUT_SHAPE_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_NUMBER_CC' , '10.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_NUMBER_CC' , '15.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_CC' , '256.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_CC' , '512.00000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_CC' , '1.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_VALIDITY_THRESHOLD_CC' , '0.25000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_FINE' , '8.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_NUMBER_FINE' , '40.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_NUMBER_FINE' , '60.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_RANGE_WIN_SIZE_FINE' , '32.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_AZIMUTH_WIN_SIZE_FINE' , '32.000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_SNR_THRESHOLD' , '3.2000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_OVERSAMPLING_COHERENCE' , '2.0000000'
   OB->SetParam , 'COREGISTRATION_CMD.CC_COH_REJECT_THRESHOLD' , '0.20000000'
   OB->SetParam , 'COREGISTRATION_CMD.COREGISTRATION_WITH_DEM_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.INTERF_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.IN_MASTER_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.IN_SLAVE_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   ;OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.DEM_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.INPUT_PARAM_FILE_NAME' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.OUT_ROOT_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.AZ_LOOKS' , '1.0000000'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.RG_LOOKS' , '1.0000000'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.ONLY_SYNT_FLAG' , 'NotOK'
   ;OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.OLD_SYNT_FILE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.REFLAT_UPHA_TOO_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_INSAR_SYNT_PHASE_GENERATION_AND_FLATTENING_CMD.CHANGE_THE_ORIGIN_NAME_FLAG' , 'OK'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

