
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Adaptive Filter and Coherence Generation 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'InSARFilterAndCoherence'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'FILTERING_CMD.FILTERING_METHOD' , 'GOLDSTEIN'
   OB->SetParam , 'FILTERING_CMD.COH_AZ_BOXSIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.COH_RG_BOXSIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.ADAPTIVE_COHERENCE_CORR_MAX_AZ_SIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.ADAPTIVE_COHERENCE_CORR_MAX_RG_SIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.COH_REM_LOCAL_FREQ_RG_BOXSIZE' , '0.0000000'
   OB->SetParam , 'FILTERING_CMD.COH_REM_LOCAL_FREQ_AZ_BOXSIZE' , '0.0000000'
   OB->SetParam , 'FILTERING_CMD.BOXCAR_WIDTH' , '4.0000000'
   OB->SetParam , 'FILTERING_CMD.BOXCAR_SNR' , '0.25000000'
   OB->SetParam , 'FILTERING_CMD.ADAPTIVE_MEAN_FACTOR' , '1.2000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_WINSIZE' , '64.000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_WIN_OVERLAP_PERC' , '80.000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_SMOOTH_WINSIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_LOWPASS_PERC' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_ALPHA_ADAPT_FLAG' , 'OK'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_MIN_ALPHA' , '0.30000000'
   OB->SetParam , 'FILTERING_CMD.GOLDSTEIN_MAX_ALPHA' , '2.5000000'
   OB->SetParam , 'FILTERING_CMD.COHERENCE_FROM_FINT_FLAG' , 'OK'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_H_FACTOR' , '30.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_T_FACTOR' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_WINDOW_SIZE' , '21.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_KERNEL_SIZE' , '7.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_MIN_KERNEL_SIZE' , '3.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_NR_OF_ITERATIONS' , '3.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_FFT_SIZE' , '64.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_SNR_THRESHOLD' , '10.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_BOXCAR_WINSIZE' , '5.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_AGGREGATION_WINSIZE' , '1.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_MIN_LOOKS' , '10.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_CPM_ALPHA' , '1.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_CPM_D0' , '0.40000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_DARK_POINT_DB' , '-15.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_BRIGHT_POINT_DB' , '3.0000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_OUTLIAR_DB' , '10.000000'
   OB->SetParam , 'FILTERING_CMD.ANL_INSAR_ENL' , '-1.0000000'
   OB->SetParam , 'MAIN_INSAR_FILTER_COHERENCE_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   OB->SetParam , 'MAIN_INSAR_FILTER_COHERENCE_CMD.INPUT_INTERF_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_FILTER_COHERENCE_CMD.INPUT_MASTER_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_FILTER_COHERENCE_CMD.INPUT_SLAVE_FILE_NAME' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_FILTER_COHERENCE_CMD.OUT_ROOT_FILE' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_INSAR_FILTER_COHERENCE_CMD.COHERENCE_FLAG' , 'OK'
   OB->SetParam , 'MAIN_INSAR_FILTER_COHERENCE_CMD.INTERF_FILT_FLAG' , 'OK'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

