
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Process Import AIS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'ImportAis'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.TIMESTAMP' , '0.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.TYPE_OF_MOBILE' , '1.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.MMSI' , '2.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.LATITUDE' , '3.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.LONGITUDE' , '4.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.NAVIGATIONAL_STATUS' , '5.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.ROT' , '6.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.SOG' , '7.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.COG' , '8.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.HEADING' , '9.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.IMO' , '10.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.CALLSIGN' , '11.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.SHIP_NAME' , '12.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.SHIP_TYPE' , '13.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.CARGO_TYPE' , '14.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.WIDTH' , '15.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.LENGTH' , '16.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.TYPE_OF_POSITION_FIXING_DEVICE' , '17.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.DRAUGHT' , '18.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.DESTINATION' , '19.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.ETA' , '20.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.DATA_SOURCE_TYPE' , '21.000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.NUMBER_OF_FIRST_LINES_TO_SKIP' , '1.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.SPEED_FACTOR' , '1.0000000'
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.SEPARATOR' , ','
   OB->SetParam , 'AIS_IMPORT_CSV_PARAMETERS_CMD.TIME_BUFFER_IN_MINUTES' , '60.000000'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   temp_value = []
   temp_value = [temp_value,'USER_PARAMETER_TO_FILL']
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.INPUT_FILE_LIST' , temp_value
   temp_value = []
   temp_value = [temp_value,'USER_PARAMETER_TO_FILL']
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.OUTPUT_FILE_LIST' , temp_value
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.INPUT_FORMAT_TYPE' , 'USER_PARAMETER_TO_FILL'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.GENERATE_KML_FLAG' , 'OK'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.IMPORT_INCORRECT_FLAG' , 'OK'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.DATE_FORMAT' , 'df_utc'
   ;OB->SetParam , 'MAIN_IMPORT_AIS_CMD.INPUT_REFERENCE_IMAGE' , 'USER_OPTIONAL_PARAMETER'
   ;OB->SetParam , 'MAIN_IMPORT_AIS_CMD.INPUT_REFERENCE_SHAPE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.DAY_MIN' , '0.0000000'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.MONTH_MIN' , '0.0000000'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.YEAR_MIN' , '0.0000000'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.DAY_MAX' , '0.0000000'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.MONTH_MAX' , '0.0000000'
   OB->SetParam , 'MAIN_IMPORT_AIS_CMD.YEAR_MAX' , '0.0000000'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

