
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Create : Import Generic SAR Data
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note : please change the values set to 'USER_PARAMETER_TO_FILL' with the appropriate value.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


   module_to_call = 'ImportSarSelector'

   OB = obj_new('SARscapeBatch',Module=module_to_call)
   IF (~OBJ_VALID(OB)) THEN BEGIN
      print, 'Create object fail : '+module_to_call
; error management
; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF

   OB->SetParam , 'SARSNT_SERVICE_SCIHUB.BASE_URL' , 'https://scihub.copernicus.eu/gnss/'
   OB->SetParam , 'SARSNT_SERVICE_SCIHUB.SEARCH_URL' , 'search'
   OB->SetParam , 'SARSNT_SERVICE_SCIHUB.DATA_URL' , 'api/stub/products?filter='
   OB->SetParam , 'SARSNT_SERVICE_SCIHUB.CONNECTION_TIMEOUT' , '60.000000'
   OB->SetParam , 'SARSNT_SERVICE_SCIHUB.DOWNLOAD_TIMEOUT' , '60.000000'
   OB->SetParam , 'SARSNT_SERVICE_SCIHUB.DOWNLOAD_SPEED' , '0.0000000'
   ;OB->SetParam , 'SARSNT_SERVICE_SCIHUB.TEMP_DIRECTORY' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'SARSNT_USER_SCIHUB.USERNAME' , 'gnssguest'
   OB->SetParam , 'SARSNT_USER_SCIHUB.PASSWORD' , 'gnssguest'
   OB->SetParam , 'SARSNT_USER_SCIHUB.PROXY_URL' , ''
   OB->SetParam , 'SARSNT_USER_SCIHUB.PROXY_USERNAME' , ''
   OB->SetParam , 'SARSNT_USER_SCIHUB.PROXY_PASSWORD' , ''
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.AVAILABLE_MEMORY_SIZE_GB' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.PFA_MAX_ITERATION' , '15.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_RG_POLY_DEGREE' , '4.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_DEGREE' , '2.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DOPPLER_AZ_POLY_NUMBER' , '20.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.LOAD_IMAGES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.DELETE_TEMPORARY_FILES' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAKE_TIFF' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.QUICK_LOOK_FORMAT' , 'ql_tiff'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SATURATION_DEFAULT' , '0.33330000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.SARSCAPE_TRACE_LEVEL' , '10.000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.RENAME_THE_FILE_USING_PARAMETERS_FLAG' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.INSERT_GEO_POINTS_FLAG' , 'NotOK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_NAME' , 'Value taken from Preferences'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_PLATFORM_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.OPENCL_DEVICE_ID' , '-1.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.GEOCODE_SCENE_LIMIT_INCREMENT' , '1000.0000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.MAX_INCIDENCE_ANGLE_DIFF_IN_A_SWATH' , '8.0000000'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_TRACE' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_STEP' , 'OK'
   OB->SetParam , 'GENERAL_PARAMETERS_CMD.VERBOSE_BAR' , 'OK'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.SARSCAPEENVIRONMENT' , 'IDL_ENVI_ENV'
   temp_value = []
   temp_value = [temp_value,'USER_PARAMETER_TO_FILL']
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.INPUT_FILE_LIST' , temp_value
   temp_value = []
   temp_value = [temp_value,'USER_PARAMETER_TO_FILL']
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.OUTPUT_FILE_LIST' , temp_value
   ;OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.INPUT_ROI_FILE' , 'USER_OPTIONAL_PARAMETER'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.MAKE_SLC_LIST_MOSAIC_FLAG' , 'OK'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.CROSS_COPOLARIZATION_FLAG' , 'ALL_POL'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.GENERATE_IW_EW_POWER_FLAG' , 'OK'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.APPLY_CALIBRATION_CONSTANT_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.GRID_SIZE_FOR_SUGGESTED_LOOKS' , '25.000000'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.SKIP_IMPORT_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.SKIP_SAMPLE_FLAG' , 'NotOK'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.DOPP_ESTIMATION_FROM_RASTER_FLAG' , 'OK'
   OB->SetParam , 'MAIN_IMPORT_SAR_SELECTOR_CMD.MAKE_ONLY_AUXILIARIES_FLAG' , 'NotOK'

   ; Verify the parameters
   ok = OB->VerifyParams(Silent=0)
   IF ~ok THEN BEGIN
      print, 'Module can not be executed; Some parameters need to be filled  ['+module_to_call+'] FAIL!'
      ; error management
      ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDIF
   ; Process execution
   OK = OB->Execute();
   IF OK THEN BEGIN
      print, 'Success execution ['+module_to_call+'] !'
   ENDIF else begin
     aErrCode = ''
     aOutMsg = get_SARscape_error_string('NotOK',ERROR_CODE=aErrCode)
     aOutMsg = get_SARscape_error_string('OK',ERROR_CODE=aErrCode)
     print, 'FAIL Execution ['+module_to_call+'] EC ['+aErrCode+'] : ['+aOutMsg+']'
     ; error management
     ; SARscape_Batch_Exit ; you have to cal this function before to exit from script
   ENDELSE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

