#!/bin/sh

# Credits:
echo "SARscape Linux patch installation script v1.2r, S. Monaco (C) sarmap SA 2015-2018" 
echo "" 

# Get params:
INSTALL_DIR=$1
ENVI_DIR=$2
if [ "$INSTALL_DIR" = "" ]; then
   echo "  Syntax . . :  install_patch.sh sarscape_dir [envi_dir]"
   echo "  Example  . :  ./install_patch.sh /usr/local/SARscape /usr/local/harris/envi55" 
   echo ""
   exit 0
fi

if [ "$ENVI_DIR" = "" ]; then
   echo "ENVI directory not specified."
   echo "SARscape will be patched for cluster mode only."
   echo "Continue with the patch installation? (y/n)"
   while true; do
      read -p "" yn
         case $yn in
            [Yy]* ) break;;
            [Nn]* ) exit;;
                * ) echo "Please type y (yes) or n (no).";;
         esac
      done
   echo ""
fi

# Admin check:
if [ "$(whoami)" != "root" ]; then
   echo "Warning: shouldn't this script be run as administrator?"
   echo ""
fi

# Check SARscape dir exists:
if [ ! -d "$INSTALL_DIR" ]; then
   echo "Error: SARscape directory '$INSTALL_DIR' not found"
   echo ""
   exit 1
fi 

if [ ! -f "$INSTALL_DIR/auxiliary/description_files/SARscape_version_id.txt" ]; then
   echo "Error: SARscape directory '$INSTALL_DIR' not found"
   echo ""
   exit 1
fi 
#cat "$INSTALL_DIR/auxiliary/description_files/SARscape_version_id.txt" | grep 5.5.2

if [ ! -d "$INSTALL_DIR/auxiliary/key_files" ]; then
   echo "Error: Invalid SARscape directory '$INSTALL_DIR' "
   echo ""
   exit 1
fi 

# Do install:
cp "./patch_sarscape.tgz" "$INSTALL_DIR/patch_sarscape.tgz"
cd "$INSTALL_DIR"
printf "   Unpacking in progress... "	   
   tar zxf patch_sarscape.tgz --no-same-owner
printf "Done\n\n"
rm -f patch_sarscape.tgz

# Update ENVI extensions:
if [ "$ENVI_DIR" != "" ]; then
   # Check ENVI dir exists:
   if [ ! -d "$ENVI_DIR" ]; then
      echo "Error: ENVI directory '$ENVI_DIR' not found"
      echo ""
      exit 1
   fi 
   export LD_LIBRARY_PATH=$INSTALL_DIR/bin   
   $INSTALL_DIR/update_envi_extensions "$INSTALL_DIR" "$ENVI_DIR" "OK"
fi

# Done:
echo "Patch installation completed"	   
echo ""
	   
	   

  
